﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        public static byte LTC3350_ADDRESS = 0x12;

        public static byte LTC3350_PERIOD   = 0x04;     //Capacitance and ESR Measurement Period
        public static byte LTC3350_CONTROL  = 0x17;     //Control Register
        public static byte LTC3350_STATUS   = 0x1C;     //Monitor Status
        public static byte LTC3350_ESR      = 0x1F;     //Measured capacitor stack equivalent series resistance (ESR) value
        public static byte LTC3350_VCAP1    = 0x20;     //Measured voltage between the CAP1 and CAPRTN pins
        public static byte LTC3350_VCAP2    = 0x21;     //Measured voltage between the CAP2 and CAP1 pins
        public static byte LTC3350_VCAP3    = 0x22;     //Measured voltage between the CAP3 and CAP2 pins
        public static byte LTC3350_VCAP4    = 0x23;     //Measured voltage between the CAP4 and CAP3 pins
        public static byte LTC3350_VIN      = 0x25;     //Measured Input Voltage
        public static byte LTC3350_VCAP     = 0x26;     //Measured Capacitor Stack Voltage
        public static byte LTC3350_VOUT     = 0x27;     //Measured Output Voltage
        public static byte LTC3350_IIN      = 0x28;     //Measured Input Current
        public static byte LTC3350_TEMP     = 0x2A;     //Measured die temperature

        public static byte gLtc3350 = 0;
        public static byte gHealth = 0;         //0:good   1:fail
        public static double gEsr = 0;          //capacitor stack equivalent series resistance (ESR) value
        public static double gVout = 0;         //output Voltage
        public static double gConsumption = 0;  //current power consumption
        public static double gEstShutTime = 0;  //est. shutdown time

        public static byte gIinCount = 0;
        public static double[] gIin = new double[20];

        private void SetSuperCapHealthNotification(byte sts)
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            //set super-cap health notification
            typ = 0;
            buf[0] = 0x54;
            buf[1] = 0xC7;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = sts;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Set Super-Cap Health Notification Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void ShowSuperCap()
        {
            byte res;
            byte i;
            byte[] buf = new byte[2];
            UInt16 d16;
            double dfloat;

            if (gLtc3350 == 1)
            {
                //ESR
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_ESR, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get ESR Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    gEsr = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    gEsr = d16 * (3.0 / 64.0);  //unit RSNSC / 64, RSNSC is 3mΩ
                }

                label20.Text = gEsr.ToString("0.00");

                //Health status
                if ((gEsr * 2 * 1.2) <= 1128)   //good
                {
                    if (gHealth == 1)
                    {
                        label23.BackColor = System.Drawing.Color.Lime;
                        label23.Text = "Good";

                        SetSuperCapHealthNotification(0);
                        gHealth = 0;
                    }
                }
                else  //fail
                {
                    if (gHealth == 0)
                    {
                        label23.BackColor = System.Drawing.Color.Red;
                        label23.Text = "Fail";

                        SetSuperCapHealthNotification(1);
                        gHealth = 1;
                    }
                }

                //Voltage
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VOUT, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get Out Voltage Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    gVout = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    gVout = d16 * 0.00221; //unit 2.21mV -> V
                }

                label8.Text = gVout.ToString("0.00");

                if (gDcIn == 1)
                {
                    //Current power consumption
                    res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_IIN, buf);
                    if (res != 0)
                    {
                        MessageBox.Show("Get Input Current Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        gConsumption = 0;
                    }
                    else
                    {
                        d16 = buf[1];
                        d16 <<= 8;
                        d16 |= buf[0];
                        gIin[gIinCount++] = d16 * (0.000001983 / 0.0025); //unit 1.983uV / RSNSI, RSNSI is 2.5mΩ
                        if (gIinCount >= 20)
                        {
                            gIinCount = 0;
                        }

                        gConsumption = 0;
                        for (i=0; i<20; i++)
                        {
                            gConsumption += gIin[i];
                        }
                        gConsumption /= 20; //average 20 times
                        gConsumption = gConsumption * gVin;
                    }

                    label5.Text = gConsumption.ToString("0.00");

                    //Est. shutdown time
                    if (gConsumption >= 10) //big than 10W, avoid low current of DC umplug
                    {
                        gEstShutTime = 1800 / gConsumption;
                        label11.Text = gEstShutTime.ToString("0");
                    }
                }
                else
                {
                    //Current power consumption
                    label5.Text = "N/A";

                    //Est. shutdown time
                    gEstShutTime--;
                    label11.Text = gEstShutTime.ToString("0");
                }

                //Status
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_STATUS, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    d16 = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                }

                label27.Text = "0x" + d16.ToString("X4");

                //VCAP
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VCAP, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get VCAP Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dfloat = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    dfloat = d16 * 0.001476; //unit 1.476mV -> V
                }

                label30.Text = dfloat.ToString("0.000");

                //VCAP1
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VCAP1, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get VCAP1 Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dfloat = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    dfloat = d16 * 0.0001835; //unit 183.5uV -> V
                }

                label24.Text = dfloat.ToString("0.000");

                //VCAP2
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VCAP2, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get VCAP2 Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dfloat = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    dfloat = d16 * 0.0001835; //unit 183.5uV -> V
                }

                label36.Text = dfloat.ToString("0.000");

                //VCAP3
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VCAP3, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get VCAP3 Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dfloat = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    dfloat = d16 * 0.0001835; //unit 183.5uV -> V
                }

                label42.Text = dfloat.ToString("0.000");

                //VCAP4
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_VCAP4, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get VCAP4 Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dfloat = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    dfloat = d16 * 0.0001835; //unit 183.5uV -> V
                }

                label48.Text = dfloat.ToString("0.000");

                //Period 
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_PERIOD, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get Period Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    d16 = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    d16 = (UInt16)(d16 * 10); //unit 10sec -> sec
                }

                label33.Text = d16.ToString();

                //Temperature
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_TEMP, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get Temperature Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dfloat = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                    dfloat = d16 * 0.028 - 251.4; //unit  0.028°C -> °C, then minus 251.4 °C
                }

                label45.Text = dfloat.ToString("0.0");

                //Control
                res = AecSmbReadWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_CONTROL, buf);
                if (res != 0)
                {
                    MessageBox.Show("Get Control Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    d16 = 0;
                }
                else
                {
                    d16 = buf[1];
                    d16 <<= 8;
                    d16 |= buf[0];
                }

                label39.Text = "0x" + d16.ToString("X4");
            }
        }

        private void ConfigSuperCap()
        {
            byte res;
            byte[] buf = new byte[2];

            if (gLtc3350 == 1)
            {
                //stop capacitance/ESR measurement
                buf[1] = 0x00;
                buf[0] = 0x0C;
                res = AecSmbWriteWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_CONTROL, buf);
                if (res != 0)
                {
                    MessageBox.Show("Stop Capacitance/ESR Measurement Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

                //capacitance and ESR measurement period:
                buf[1] = 0x00;
                buf[0] = 0x06;
                res = AecSmbWriteWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_PERIOD, buf);
                if (res != 0)
                {
                    MessageBox.Show("Set Capacitance/ESR Measurement Period Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

                //start capacitance/ESR measurement
                buf[1] = 0x00;
                buf[0] = 0x09;
                res = AecSmbWriteWord(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS, LTC3350_CONTROL, buf);
                if (res != 0)
                {
                    MessageBox.Show("Start Capacitance/ESR Measurement Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }
    }
}
